function [vstk,filenames,imgclass,info] = openvstk(dirname,skip)
%Open a virtual stack
%Synatax:   [] = openvstk(dirname,1)
%Input:     dirname = directory the data is
%           skip = if you want to open an interleaved series of images. For
%               example: every other skip=2, every 10th skip = 10, default
%               = 1 (every image)
%Output:    vstk = the image stack as a matrix
%           filenames = the names of all the files, in cell array
%           info = information regarding the images, from iminfo
%           imgclass = the image class of the image matrix, e.g., 'uint16'

if nargin<2
    skip = 1;   %by default open every image
end
%grab the filenames in the current directory
dir_struct = dir(dirname);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
filenames = {dir_struct.name};   %grab the all of the names in the root
filenames = filenames(~idx);  %don't want the first two
filenames = findimgs(filenames);    %only the images please
%Put the virtual stack into an actual volume
info = imfinfo([dirname,filesep,filenames{1}]);     %grab the file info
switch info.BitDepth    %what is the bit depth
    case 8
        imgclass = 'uint8';
    case 16
        imgclass = 'uint16';
    case 32
        imgclass = 'uint32';
    otherwise
        imgclass = 'double';
end
vstk = zeros(info.Height,info.Width,size(filenames,2),imgclass); %generate holder variable

%now go through each file 
h = waitbar(0,'Opening Image: ','position',[10 50 275 50]);     %initiate progress bar
for l = 1:skip:size(filenames,2)
    waitbar(l/size(filenames,2),h,['Opening Image: ',filenames{l}]);   %update progress
    vstk(:,:,l) = imread([dirname,filesep,filenames{l}]);  %grab the image
end
close(h)